<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class ChatbotController extends Controller
{
    public function chat(Request $request)
    {
        // احصل على سجل المحادثة من الطلب
        $chatHistory = $request->input('contents');

        // احصل على مفتاح API من ملف .env
        // إذا لم يكن موجودًا، سيتم استخدام مفتاح عام للوصول المحدود
        $apiKey = env('GEMINI_API_KEY', '');

        // إرسال الطلب إلى Google Gemini API
        $response = Http::withOptions([
            'verify' => false, // تجاهل التحقق من SSL في البيئة المحلية فقط
        ])->post("https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash:generateContent?key={$apiKey}", [
            'contents' => $chatHistory
        ]);

        // تحقق من نجاح الطلب
        if ($response->successful()) {
            // استخراج النص من الإجابة
            $text = $response->json('candidates.0.content.parts.0.text');
            return response()->json(['text' => $text]);
        }

        // في حالة حدوث خطأ، قم بإرجاع رسالة خطأ
        return response()->json(['error' => 'Failed to get response from Gemini API.'], $response->status());
    }
}

